#! /usr/local/bin/R
#
# reg_event_study.R
#
#
#
#
#
# Created on     January  05th 2020
# Last modified  February 12th 2020
#
#
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
library(crayon)
library(devtools)

library(brew)
library(magrittr,warn.conflicts = F,quietly = T);
library(stringr,warn.conflicts = F,quietly = T);
library(glue,warn.conflicts = F,quietly = T)
library(data.table,warn.conflicts = F,quietly = T);
library(statar,warn.conflicts = F,quietly = T)
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
star_maker <- function(x){
  ifelse(x>0.1, "", ifelse(x>0.05, "^{*}", ifelse(x>0.01, "^{**}", "^{***}") ) )
}
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
prep_coef_DiD <- function(var, input, reg_type="gravity"){
  dt1 <- fread(glue("./output/coef_for_plots/coef_for_plot_postest_{reg_type}_{input}_{var}.txt"), skip=3)
  setnames(dt1, c("lag", "att", "se", "pval"))
  dt1[, att := as.numeric(att) ]
  dt1 <- dt1[ !is.na(att) ]
  dt1[, horizon := as.numeric(gsub("\\D", "", lag)) ]
  dt1 <- dt1[, .(year_diff=fifelse(str_sub(lag, 1, 1)=="l", -1, 1) * horizon, 
                 att=as.numeric(att), se=as.numeric(se), pval = as.numeric(pval) ) ]
  dt1 <- dt1[ !is.na(year_diff) & !is.na(se) ]
  return(dt1)
}

prep_otherstats_DiD <- function(var, input, reg_type="gravity"){
  dt1 <- fread(glue("./output/coef_for_plots/coef_for_plot_postest_{reg_type}_{input}_{var}.txt"), skip=3)
  setnames(dt1, c("col_name", "stat", "se", "pval"))
  dt1 <- data.table(r2 = dt1[col_name=="r2"][["stat"]], N = dt1[col_name=="N"][["stat"]])
  return(dt1)
}

var = "log_import"
ext = "PCA"

prep_coef_DiD(var, ext, reg_type = "gravity")[abs(year_diff)<=10][, var_name := var][]
prep_otherstats_DiD(var, ext, reg_type = "gravity")

#prep_coef_DiD(var, ext, reg_type = "fe")[abs(year_diff)<=10][, var_name := var][]
#prep_otherstats_DiD(var, ext, reg_type = "fe")
# ------------------------------------------------------------------------------------------

## Loops over types of deals
dlist <- c("PCA", "PCA_resid")

for (ext in dlist) {
  
  # ------------------------------------------------------------------------------------------
  dt_dyn_full_gravity <- data.table()
  for (var in c("log_import", "fx_vol", "var_adj", "R2_y", "beta", "win_log_import")){
    dt_dyn_full_gravity <- rbind(dt_dyn_full_gravity,
                                 cbind(prep_coef_DiD(var, ext, reg_type = "gravity")[abs(year_diff)<=10][, var_name := var],
                                       prep_otherstats_DiD(var, ext, reg_type = "gravity")) )
  }
  dt_dyn_full_gravity[]
  dt_dyn_full <- copy(dt_dyn_full_gravity)
  
  
  if (ext == "PCA") {
    brew("./input/tables/table_event_reg.brew.tex", "./output/tables/table7.tex")
  }
  else {
    brew("./input/tables/table_event_reg.brew.tex", "./output/tables/tableA7.tex")
  }
  # ------------------------------------------------------------------------------------------
  
  
}

